<?php
namespace App\Models\Procurement\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Procurement;
use App\Models\People\Supplier;
use App\Models\People\Warehouse;
use App\Models\Procurement\Inventory\Item;
class Inventory extends Model
{

    use HasFactory;
    protected $guarded = ['id'];
   /* protected $fillable = [
        'organisation_id',       // Add this line
        'item_id',       // Add this line
        'product_id',
        'warehouse_id',
        'quantity',
        'received_date',
        // Add any other fields that you need to be mass-assignable
    ]; */
    /**
     * ItemStock belongs to Item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        // belongsTo(RelatedModel, foreignKey = item_id, keyOnRelatedModel = id)
        return $this->belongsTo(Item::class);
    }
    public function warehouse(){
        // belongsTo(RelatedModel, foreignKey = item_id, keyOnRelatedModel = id)
        return $this->belongsTo(Warehouse::class);
    }
    public function supplier(){
        // belongsTo(RelatedModel, foreignKey = item_id, keyOnRelatedModel = id)
        return $this->belongsTo(Supplier::class);
    }
}
