<?php

namespace App\Models\Procurement\inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Currency;
use App\Models\Procurement\Inventory\Item;
class ItemVariant extends Model
{
    use HasFactory;
    protected $guarded = ['id'];
    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function item()
    {
        return $this->belongsTo(Item::class);
    }
    public function variant_attributes()
    {
        return $this->hasMany(VariantAttribute::class);
    }
    public function currency() {
        return $this->belongsTo(Currency::class);
    }

}
