<?php

namespace App\Models\Procurement;
use App\Models\People\Customer;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quotation extends Model
{
    use HasFactory,softDeletes;

    /**
     * Quotation has many Items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function items()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = quotation_id, localKey = id)
        return $this->hasMany(QuotationItem::class);
    }

    /**
     * Quotation belongs to Customer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        // belongsTo(RelatedModel, foreignKey = customer_id, keyOnRelatedModel = id)
        return $this->belongsTo(Customer::class);
    }
}
