<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCashFlowReportCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cash_flow_report_categories', function (Blueprint $table) {
            $table->id(); 
            $table->string('name'); 
            $table->enum("section",["operating", "investing", "financing"]);
            $table->text('description')->nullable();  
            $table->unsignedBigInteger('parent_id')->nullable();
             // Add the foreign key constraint
             $table->foreign('parent_id')
             ->references('id')
             ->on('cash_flow_report_categories')
             ->onDelete('set null');
             $table->softDeletes();
            $table->timestamps(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cash_flow_report_categories');
    }
}
