<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBudgetsTable extends Migration
{
    /**
     * Run the migrations.
     * @return void
     */
    public function up()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::create('budget_categories', function (Blueprint $table) {
            $table->uuid("id")->primary();
            $table->uuid('organisation_id'); 
            $table->string('name')->unique(); // e.g., Operational, Capital Expenditure
            $table->string('description')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
        
        Schema::create('budgets', function (Blueprint $table) {
             // Disable foreign key checks
            $table->uuid("id")->primary(); 
            $table->uuid('organisation_id');  
            $table->string('name');  
            $table->decimal('allocated_amount',20,2);
            $table->decimal('spent_amount',20,2)->default(0);
            $table->decimal('remaining_amount',20,2)->default(0);
            $table->foreignId('currency_id')->constrained("currencies"); 
            $table->string('description')->nullable();
            $table->uuid('parent_id')->nullable();
            $table->foreignId('fiscal_year_id')->constrained("fiscal_years"); 
            $table->uuid('budget_category_id')->nullable();
            $table->softDeletes();
            $table->timestamps(); 

            $table->foreign('budget_category_id')->references('id')->on('budget_categories')->cascadeOnDelete();
            $table->foreign('parent_id')->references('id')->on('budgets')->cascadeOnDelete();
          
        });
        Schema::create('budget_allocations', function (Blueprint $table) {
            $table->uuid("id")->primary();
            $table->uuid('budget_id');
            $table->string('name'); // Allocation name, e.g., "Marketing Campaign Q1"
            $table->foreignId('project_id')->nullable()->constrained('projects')->onDelete('set null');
            $table->foreignId('activity_id')->nullable()->constrained('activities')->onDelete('set null');
            $table->decimal('allocated_amount', 20, 2);
            $table->decimal('spent_amount', 20, 2)->default(0);
            $table->decimal('remaining_amount', 20, 2)->storedAs('allocated_amount - spent_amount');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->foreign('budget_id')->references('id')->on('budgets')->cascadeOnDelete();
        });
        Schema::create('budget_items', function (Blueprint $table) {
            $table->uuid("id")->primary();
            $table->string('name');  
            $table->enum("type",['Revenue','Expense']);//'Asset','Liability','Cash_inflow',, 'Cash_outflow'
            $table->decimal('amount', 20, 2);
            $table->decimal('currency_rate', 20, 2);
            $table->decimal('amount_in_base_currency', 20, 2)->storedAs("amount * currency_rate");
            $table->foreignId('chart_of_account_id')->constrained("chart_of_accounts");   
            $table->uuid('budget_allocation_id')->nullable();
            $table->uuid('budget_id');
            $table->boolean('status')->default(1); 
            $table->string('description')->nullable();
            $table->softDeletes();
            $table->timestamps(); 
            $table->foreign('budget_id')->references('id')->on('budgets')->cascadeOnDelete();
            $table->foreign('budget_allocation_id')->references('id')->on('budget_allocations')->cascadeOnDelete();
        });
       
        
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::dropIfExists('budget_categories');
        Schema::dropIfExists('budgets');
        Schema::dropIfExists('budget_allocations');
        Schema::dropIfExists('budget_items');
        \DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
