<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
class CreateJournalTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('journal_transactions', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->foreignId("branch_id")->nullable();
            $table->timestamp('transaction_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->enum("status", ["active", "deleted", "reversed"])->default('active');
            $table->string("reference")->nullable();
            $table->string("supporting_documents")->nullable();
            $table->foreignId("project_id")->nullable()->constrained("projects");
            $table->foreignId("segment_id")->nullable()->constrained("segments");
            $table->uuid("budget_id")->nullable();
            $table->foreignId("journal_type_id")->nullable()->constrained("journal_types");
            $table->foreignId("fiscal_year_id")->constrained("fiscal_years");
            $table->string("description")->nullable();
            $table->integer("reversed_by")->nullable();
            $table->string("reverse_message")->nullable();
            $table->date("reversal_date")->nullable();
            $table->string("unique_id")->nullable();
            $table->index('fiscal_year_id');
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('budget_id')->references('id')->on('budgets')->cascadeOnDelete();
        });
        Schema::create('journal_line_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('journal_transaction_id')->constrained('journal_transactions', 'id')->index();
            $table->double('amount');
            $table->decimal('base_currency_amount', 15, 4);
            $table->foreignId('credit_account_id')->nullable()->constrained("chart_of_accounts")->index('credit_account_id');
            $table->foreignId('debit_account_id')->nullable()->constrained("chart_of_accounts")->index('debit_account_id');
            $table->decimal("currency_rate",15,4)->nullable();
            $table->foreignId("currency_id")->constrained('currencies');
            $table->foreignId("base_currency_id")->constrained('currencies');
            $table->timestamp('transaction_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string("unique_id")->nullable();
            $table->index('journal_transaction_id');
            $table->softDeletes();
            $table->timestamps();
        });
        Schema::create('bank_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bank_account_id')->constrained('chart_of_accounts', "id");
            $table->date('transaction_date');
            $table->decimal('amount', 15, 4);
            $table->string('description')->nullable(); // Bank statement reference
            $table->string('reference_number')->nullable(); 
            $table->boolean('reconciled')->nullable(false); 
            $table->timestamps();
        });
        Schema::create('bank_reconciliations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('journal_transaction_id')->constrained('journal_transactions');
            $table->foreignId('bank_account_id')->constrained('chart_of_accounts', "id");
            $table->decimal('reconciled_amount', 15, 4);
            $table->date('reconciliation_date');
            $table->string('reference')->nullable(); // Bank statement reference
            $table->foreignId('reconciled_by')->constrained('employees', 'id'); // User who reconciled
            $table->string('notes')->nullable(); // Optional comments
            $table->timestamps();
        });
        
    }


 
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('journal_transactions');
        Schema::dropIfExists('journal_line_transactions');
        
    }
}
