<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('amcos_warehouses', function (Blueprint $table) {
            $table->uuid("id")->primary(); 
            $table->uuid('organisation_id');
            $table->string('name'); 
            $table->string('code')->nullable(); 
            $table->decimal("capacity", 10,2);
            $table->uuid('muvu_uid')->nullable(); 
            $table->timestamps(); 
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('amcos_warehouses');
    }
};
