<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('members', function (Blueprint $table) {
            $table->uuid('id')->primary(); 
            $table->uuid("amcos_id"); 
            $table->enum("registrationType", ["MEMBER", "NON-MEMBER"]); 
            $table->string("nin")->nullable()->unique();
            $table->string("firstName");
            $table->string("lastName");
            $table->string("middleName")->nullable();
            $table->date("dateOfBirth")->nullable();
            $table->string("phoneNumber")->nullable()->unique();
            $table->decimal("noOfShares", 10,2)->default(0);
            $table->string("wardPostCode")->nullable();
            $table->string("referenceNumber")->nullable()->unique();
            $table->enum("maritalStatus", ["SINGLE", "MARRIED", "DIVORCED"])->default("SINGLE");
            $table->enum("gender", ["MALE", "FEMALE"]);
            $table->string("villageStreet")->nullable();
            $table->string("address")->nullable();
            $table->string("tinNumber")->nullable();
            $table->string("email")->nullable();
            $table->uuid("educationLevelUid")->nullable();
            $table->string("nationality");
            $table->boolean("contactPerson")->default(false);
            $table->boolean("steeringCommittee")->default(false);
            $table->string('description')->nullable(); 
            $table->string('muvu_uid')->nullable(); 
            $table->string('membershipNumber')->nullable(); 
            $table->timestamps(); 
            $table->softDeletes(); 

            $table->foreign('educationLevelUid')->references('id')->on('education_levels')->cascadeOnDelete();
            
        });
        Schema::create('successors', function (Blueprint $table) {
            $table->uuid('id')->primary(); 
            $table->uuid("member_id"); 
            $table->string("nin")->nullable();
            $table->string("firstName");
            $table->string("lastName");
            $table->string("middleName")->nullable();
            $table->enum("gender", ["MALE", "FEMALE"]);
            $table->date("dateOfBirth")->nullable();
            $table->string("phoneNumber")->nullable();
            $table->string("referenceNumber")->nullable();
            $table->string("address")->nullable();
            $table->string("email")->nullable();
            $table->enum("relationshipType", ["son", "Mother", "Father", "Daughter", "Brother","Sister", "Uncle", "Aunt", "Nephew", "Niece", "Cousin", "Gandfather", "Grandmother", "Grandson", "Granddaughter", "Husband", "Wife", "Spouse", "Partner", "Fiance", "Friend", "Neighbour", "Colleague"]);
            $table->string("nationality");
            $table->timestamps(); 
            $table->softDeletes(); 
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('farmer_sales');
    }
};
