<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mcos_financial_years', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->integer('startYear');
            $table->integer('endYear'); 
            $table->enum('state', ["PREVIOUS", "CURRENT", "NEXT"]); 
            $table->uuid('muvu_uid')->nullable();
            $table->timestamps(); 
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mcos_financial_years');
    }
};
