<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{ /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('financing_agreements', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');//->constrained("organisations");
            $table->string('financing_no')->nullable();
            $table->foreignId('asset_id')->constrained("assets");
            $table->foreignId('borrower_id');
            $table->enum("status", ['pending','active','completed','foreclosed'])->default('pending');
            $table->decimal('loan_amount', 19, 2);
            $table->decimal('ltv_ratio', 5, 2);
            $table->decimal('interest_rate', 5, 2);
            $table->integer("term_duration");
            $table->decimal("instament_amount", 19,2);
            $table->date('application_date');
            $table->date('disbursement_date');
            $table->date('end_date');
            $table->enum("foreclosure_status", ['none','pending','completed'])->default('none');
            $table->integer('repayment_frequency');//1-Monthly
            $table->enum('repayment_made_every', ['monthly', 'pending', 'completed']);
            $table->text('purpose')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('financing_agreements');
    }
};
