<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBorrowedLoanInstallmentPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ownership_documents', function (Blueprint $table) {
            $table->id(); // Primary Key: Auto-increment ID
            $table->foreignId('asset_id')->constrained('assets')->onDelete('cascade'); // Link to assets table
            $table->string('document_name'); // Name of the document (e.g., "Title Deed", "Ownership Certificate")
            $table->string('document_url');  // Storage path or URL for the uploaded file
            $table->string('description');  // Storage path or URL for the uploaded file
            $table->timestamps(); // Created_at and Updated_at fields
        });
       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ownership_documents');
    }
}
