<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_payments', function (Blueprint $table) {
            $table->id();
            $table->integer('asset_id');
            $table->integer('fund_source_account_id');
            $table->integer('transaction_type_id')->default(2)->comment('1 for credit 2 for debit 3 for reverse');
            $table->integer('loss_or_gain_addition')->comment('1 loss ,2 gain and 3 addition')->nullable();
            $table->decimal('amount',20,2);
            $table->date('transaction_date');
            $table->string('narrative')->nullable();
            $table->integer('reversed_by')->nullable();
            $table->string('reverse_msg')->nullable();
            $table->string('reversed_date')->nullable();
            $table->integer('status')->default(1);
            $table->string('unique_id')->default(1);
            $table->timestamps();
        });
    }

    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_payments');
    }
};
