<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_expenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->constrained("assets");
            $table->decimal('amount',20,2);
            $table->datetime('transaction_date');
            $table->string('narrative')->nullable();
            $table->enum('status', [1,0])->default(1);
            $table->integer('reverse_by')->nullable();
            $table->string('reverse_msg')->nullable();
            $table->date('reversed_date')->nullable();
            $table->uuid('organisation_id');
            $table->uuid('branch_id')->nullable();
            $table->timestamps();
        });
    }
 
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_expenses');
    }
};
