<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appreciations', function (Blueprint $table) {
            $table->id();
            $table->integer('asset_id');
            $table->string('transaction_no');
            $table->foreignId('fund_source_account_id');
            $table->integer('payment_id');
            $table->decimal('amount',20,2);
            $table->datetime('transaction_date');
            $table->integer('fiscal_year_id');
            $table->string('narrative');
            $table->string('unique_id');
            $table->string('month')->nullable();
            $table->integer('status_id')->default(1);
            $table->string('reference_no')->nullable();
            $table->string('reference_id')->nullable();
            $table->integer('created_by');
            $table->integer('modified_by')->nullable();
            $table->string('reversed_by')->nullable();
            $table->string('reverse_msg')->nullable();
            $table->string('reversed_date')->nullable();
            $table->integer('organisation_id');
            $table->integer('branch_id');
            $table->timestamps();
             
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_appreciations');
    }
};
