<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBorrowedLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('borrowed_loans', function (Blueprint $table) {
            $table->id();
            $table->string('loan_no')->nullable();
            $table->unsignedBigInteger('lender_id');
            $table->unsignedBigInteger('org_id');
            $table->unsignedBigInteger('branch_id')->nullable()->default(1);
            $table->unsignedBigInteger('staff_id');
            $table->unsignedBigInteger('status_id')->default(1)->nullable();
            $table->unsignedBigInteger('borrowing_product_id')->nullable()->default(1);
            $table->decimal('loan_amount', 19, 2);
            $table->date('application_date');
            $table->unsignedBigInteger('cash_account_id');
            $table->date('date_received')->nullable();
            $table->decimal('interest_rate', 5, 2);
            $table->integer('offset_period');
            $table->string('offset_made_every');
            $table->integer('grace_period');
            $table->string('repayment_frequency');
            $table->string('repayment_made_every');
            $table->integer('installments');
            $table->foreignId('loan_state_id');
            $table->text('loan_purpose')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('modified_by')->nullable();
            $table->string('unique_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('borrowed_loans');
    }
}