<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBorrowedLoanInstallmentPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('borrowed_loan_installment_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('borrowed_loan__repayment_schedule_id')->nullable();
            $table->foreignId('borrowed_loan_id');
            $table->decimal('paid_interest', 19, 2);
            $table->decimal('paid_principal', 19, 2);
            $table->decimal('paid_penalty', 19, 2)->default(0)->nullable();
            $table->decimal('principal_over', 19, 2)->nullable();
            $table->decimal('interest_over', 19, 2)->nullable();
            $table->decimal('forgiven_interest', 19, 2)->default(0)->nullable();
            $table->decimal('forgiven_penalty', 19, 2)->default(0)->nullable();
            $table->date('payment_date');
            $table->text('comment');
            $table->integer('transaction_channel_id')->nullable();
            $table->integer('status_id')->default(1)->nullable();
            $table->integer('previous_payment_status')->nullable();
            $table->dateTime('previous_payment_date')->nullable();
            $table->string('reversal_reason', 200)->nullable();
            $table->foreignId('reversed_by')->nullable();
            $table->string('unique_id', 200);
            $table->foreignId('created_by');
            $table->foreignId('modified_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('borrowed_loan_installment_payments');
    }
}