<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
          Schema::create('employee_warehouse', function (Blueprint $table) {
               $table->id();
               $table->foreignId('employee_id')->constrained("employees");
               $table->foreignId('warehouse_id')->constrained("warehouses");
               $table->timestamps();
          });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_warehouse');
    }
};
