<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('production_plans', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->date('planned_start_date');
            $table->date('planned_end_date');
            $table->decimal('quantity', 8, 2);
            $table->enum('status', ['pending', 'in_progress', 'completed'])->default('pending');
            $table->string("description")->nullable();
            $table->timestamps();
        });
        Schema::create('production_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('production_plan_id')->constrained('production_plans')->onDelete('cascade');
            $table->foreignId('work_order_id')->constrained('work_orders')->onDelete('cascade');
            $table->foreignId('machine_id')->constrained('machines')->onDelete('cascade');
            $table->timestamp('start_time');
            $table->timestamp('end_time')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();
        });
        Schema::create('material_plans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('production_plan_id')->constrained('production_plans')->onDelete('cascade');
            $table->date('material_required_date');
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->decimal('quantity', 8, 2);
            $table->decimal('material_cost', 8, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('production_plans');
        Schema::dropIfExists('production_schedules');
        Schema::dropIfExists('material_plans');
    }
};
