<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::create('purchase_requests', function (Blueprint $table) {
           // DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            $table->id();
            $table->string('purchase_request_no')->unique();
            $table->uuid('organisation_id');
            $table->string('name');  
            $table->foreignId('requested_by');
            $table->string('requested_by_name')->nullable();
            $table->double('total_cost', 20,4)->default(0);
            $table->decimal('approved_total_cost', 20, 2)->default(0);
            $table->string('request_comment')->nullable();
            $table->date('request_date');
            $table->foreignId('current_approval_level');
            $table->enum('status',["pending", "reviewed","partial_aproval", "approved", "rejected"])->default("pending");
            $table->foreignId("cash_requisition_id")->nullable();
            $table->foreignId("department_id")->nullable()->constained("departments");
            $table->uuid("budget_id")->nullable();           
            $table->foreignId('branch_id')->nullable();
            $table->foreignId('segment_id')->nullable();
            $table->foreignId('project_id')->nullable();
            /*
            $table->foreignId('reviewed_by')->nullable();
            $table->string('reviewer_comment')->nullable();
            $table->datetime('review_date')->nullable();
            $table->foreignId('approved_by')->nullable();
            $table->string('approval_comment')->nullable();
            $table->datetime('approval_date')->nullable();            
            $table->foreignId('rejected_by')->nullable();
            $table->string('rejected_comment')->nullable();
            $table->datetime('rejected_date')->nullable();   */
                     
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('budget_id')->references('id')->on('budgets')->cascadeOnDelete();
           
        });
        Schema::create('purchase_request_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId("purchase_request_id")->constrained("purchase_requests");
            $table->foreignId('item_id')->constrained('items');
            $table->string('item_name')->nullable();
            $table->uuid('budget_item_id')->nullable();
            
            $table->integer('quantity'); // Non-nullable
            $table->decimal('unit_price_estimate', 20, 2); // Non-nullable
        
            $table->decimal('total_price_estimate', 20, 2);// Handles NULL values
        
            $table->integer("approved_quantity")->default(0);
            $table->decimal("approved_unit_price_estimate", 20, 2)->default(0);
            $table->decimal("approved_total_price_estimate", 20, 2);
            
            $table->enum("status", ['pending', 'reviewed', 'approved', 'rejected'])->default('pending');
            $table->foreignId('currency_id')->constrained('currencies');
            $table->text("notes")->nullable();
            $table->timestamps();
            $table->foreign('budget_item_id')->references('id')->on('budget_items')->cascadeOnDelete();
        });
        
        

        Schema::create('purchase_request_approval_workflows', function (Blueprint $table) {
            $table->id();
            $table->foreignId('purchase_request_id')->constrained("purchase_requests");
            $table->foreignId('approver_id');
            $table->string('approver_name')->nullable();
            $table->foreignId('level');
            $table->enum("status", ['pending','reviewed', 'approved', 'rejected'])->default('pending');
            $table->string('remarks')->nullable();
            $table->timestamps();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        });
        Schema::create('purchase_quantity_changes', function (Blueprint $table) {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            $table->id();
            $table->foreignId('purchase_request_item_id')->constrained("purchase_request_items");
            $table->foreignId('changed_by');// the approver who changed the quantity
            $table->string('changed_by_name')->nullable();
            $table->integer('old_quantity');
            $table->integer('new_quantity');
            $table->string('change_reason')->nullable();
            $table->timestamps();
            //DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        });
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**

     * 
     * 
     * 
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::dropIfExists('purchase_requests');
        Schema::dropIfExists('purchase_request_items');
        Schema::dropIfExists('requisition_approval_workflow');
        Schema::dropIfExists('requisition_quantity_changes');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
};
