<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('request_for_quotations', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->foreignId('purchase_request_id')->nullable()->constrained('purchase_requests');
            $table->string('title');
            $table->string('description')->nullable();
            $table->date('submission_deadline');
            $table->decimal('budget',18,2);
            $table->foreignId('currency_id')->constrained("currencies");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('request_for_quotations');
    }
};