<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('evaluations', function (Blueprint $table) {
            $table->id();
           // $table->foreignId('request_for_quotation_id')->constrained("request_for_quotations");
            $table->foreignId('evaluation_criteria_id')->constrained("evaluation_criterias");
            $table->foreignId('bid_id')->constrained("bids");
            $table->integer('score');
            $table->string('comments')->nullable();
            $table->datetime('evaluated_at');
            $table->string('attachment')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evaluations');
    }
};