<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('purchase_order_id')->constrained("purchase_orders");
            $table->foreignId('item_id')->constrained("items");
            $table->integer('quantity');
            $table->decimal('unit_price', 18,2);
            $table->decimal('total_price', 18,2)->storedAs('quantity * unit_price');
            $table->foreignId('currency_id')->constrained("currencies");
            $table->enum('delivery_status', ['pending', 'delivered', 'partial'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_order_items');
    }
};
