<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grns', function (Blueprint $table) {
            $table->id();
            $table->string('grn_no');
            $table->uuid('organisation_id'); 
            $table->foreignId('purchase_order_id')->constrained("purchase_orders");
            $table->date('receipt_date');
            $table->foreignId('received_by');
            $table->foreignId('truck_id')->nullable();
            $table->foreignId('driver_id')->nullable();
            $table->string('delivery_note_number');
            $table->string('attachment')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grns');
    }
};
