<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('suppliers', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->string("supplier_name");
            $table->text('address');
            $table->string('email');
            $table->string('contact_person')->nullable();
            $table->string('contact_person_title')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('company_registration_number')->nullable();
            $table->string('tax_identification_number')->nullable();
            $table->decimal('credit_limit', 10, 2)->nullable();
            $table->enum('supplier_type', ['Local', 'International'])->default("Local");
            $table->enum('status', ['active', 'inactive', 'suspended'])->default("active");
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suppliers');
    }
};
