<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('items', function (Blueprint $table) {
            $table->id(); 
            $table->foreignId('item_category_id')->constrained('item_categories'); 
            $table->uuid('organisation_id'); //->constrained('unit_of_measures'); 
            $table->foreignId('unit_of_measure_id')->constrained('unit_of_measures'); 
            $table->foreignId('currency_id')->constrained('currencies'); 
            $table->foreignId('brand_id')->nullable()->constrained('brands');
            $table->string('name'); 
            //The expense ledger to truck the item
            $table->foreignId('chart_of_account_id')->constrained('chart_of_accounts'); 
            $table->enum('item_type', ['physical','service', 'asset','consumable','digital_good','subscriptions', 'raw_material', 'semi_finished', 'finished_good'])->default('physical'); 
            $table->decimal('cost_price', 10,2)->default(0); 
            $table->decimal('selling_price', 10,2)->default(0); 
            $table->decimal('vat', 8,2)->default(0);  
            $table->string('reference')->nullable(); 
            $table->string('barcode')->nullable(); 
            $table->string('stock_alert_level')->nullable(); 
            $table->string('sku_unit')->nullable(); 
            $table->boolean('has_expiry')->default(false); 
            $table->string('shell_life')->nullable(); 
            $table->text('description')->nullable(); 
            
            $table->timestamps(); 
            
        });
        Schema::create('item_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('item_id')->constrained()->onDelete('cascade');
            $table->string('image_url');
            $table->timestamps();
        });
        Schema::create('discounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->enum('discount_type', ['percentage', 'fixed'])->default('percentage');
            $table->decimal('discount_value', 10, 2);
            $table->date('start_date');
            $table->date('end_date');
            $table->timestamp('created_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('items');
        Schema::dropIfExists('item_images');
        Schema::dropIfExists('discounts');
    }
};
