<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('variant_attributes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('item_variant_id')->constrained()->onDelete('cascade'); // Links to product_variants table
            $table->foreignId('attribute_value_id')->constrained()->onDelete('cascade'); // Links to attribute_values table
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('variant_attributes');
    }
};
