<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->foreignId("project_category_id")->constrained("project_categories");
            $table->string("name");
            $table->foreignId("sector_id")->nullable()->constrained("sectors");
            $table->enum("prioty", ['High', 'Medium', 'Low'])->default('Low');
            $table->enum("status", ['Not Started', 'In Progress', 'Completed', 'On Hold', 'Cancelled'])->default('Not Started');
            $table->decimal("cost", 20,2)->nullable();
            $table->text("challenges")->nullable();
            $table->string("location")->nullable();
            $table->enum("reporting_period",['Daily','Weekly',"Bi-weekly", 'Monthly', "Quarterly","Semi-Annually", "Annually", "Biennially", "Ad-hoc"]); //Ad-hoc reported as of need basis, Biennially reports produced every two years
            $table->foreignId("project_manager");
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->text('recommendations')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
