<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('activity_parameter_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('activity_id')->constrained("activities");
            $table->foreignId('activity_parameter_id')->constrained("activity_parameters");
            $table->string('result');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_parameter_results');
    }
};
