<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('activity_approvals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('activity_id');
            $table->foreignId('approved_by')->constrained("staff");
            $table->date("approval_date");
            $table->string('comment')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_approvals');
    }
};
