<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->uuid("id")->primary();
            $table->enum("type",['individual', 'organisation']);
            $table->string('organization_name')->nullable();
            $table->enum('salutation', ['Mr', "Mrs","Ms", "Miss", "Dr", "Prof", "Rev"]);
            $table->string('first_name');
            $table->string('last_name');
            $table->string('other_name');
            $table->string('email')->unique()->nullable();
            $table->string('phone')->nullable();
            //$table->string('phone')->nullable();
            $table->string('industry')->nullable();
            $table->foreignId('currency_id')->nullable()->constrained("currencies");
            $table->text('headquarters_address')->nullable();
            $table->text('billing_address')->nullable();
            $table->text('shipping_address')->nullable();
            $table->string('payment_terms')->nullable();
            $table->decimal('credit_limit', 10, 2)->nullable();
            $table->enum('status', ['active', 'inactive', 'suspended'])->default('active');
            $table->text('bank_details')->nullable();
            $table->string('tax_identification_number')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
