<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuotationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotations', function (Blueprint $table) {
            \DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            $table->id();
            $table->string('qoutation_no');
            $table->string('title');
            $table->uuid("organisation_id");//->constrained("organisations");
            $table->uuid('customer_id');
            $table->foreignId('opportunity')->nullable()->constrained("opportunities");
            $table->foreignId('currency_id')->nullable()->constrained("currencies");
            $table->string('issue_date');
            $table->string('expiry_date');
            $table->string('net_amount')->nullable();
            $table->string('vat_rate')->nullable();
            $table->decimal('total_amount', 20, 2)->storedAs('net_amount + (net_amount * vat_rate)');
            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->enum('q_type', ['item', 'service'])->default('item');
            $table->string('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
            \DB::statement('SET FOREIGN_KEY_CHECKS = 1;');
        });
        Schema::create('quotation_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('quotation_id')->constrained("quotations");
            $table->foreignId('item_id');
            $table->string('quantity');
            $table->decimal('unit_price', 18, 2);
            $table->decimal('total_price', 18,2)->storedAs('quantity * unit_price');
            $table->foreignId('currency_id')->constrained("currencies");
            $table->string('notes')->nullable();

            $table->timestamps();
        });
        Schema::create('quotation_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('quotation_id')->constrained('quotations')->onDelete('cascade');
            $table->foreignId('service_id')->constrained('services');
            $table->foreignId('unit_of_measure_id')->constrained('unit_of_measures');
            $table->decimal('unit_price', 20, 2)->nullable();
            $table->integer('quantity')->nullable();
            $table->decimal('total_cost', 20, 2)->storedAs('unit_price * quantity');
            $table->foreignId('currency_id')->constrained("currencies");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotations');
        Schema::dropIfExists('quotation_items');
        Schema::dropIfExists('quotation_services');
    }
}
